--TODO: tee nist moduuleja joita voi kytt luokkien tapaan...
require 'g_level'
require 'g_sewer_aid'
g_level.reset()

--INIT TEXTURES  -- adds a texture into ObjectManager<Texture>
h = FM_NEAREST;

-- textures
lua_init_texture("sewer_tileset", "data/images/sewer/sewer_tileset.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("sewer_tileset2", "data/images/sewer/sewer_tileset2.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("sewer_objects", "data/images/sewer/sewer_objects_1.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("sewer_steam", "data/images/sewer/steam.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("sewer_unstable_floor", "data/images/sewer/sewer_objects_1.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)

lua_init_texture("sewer_fore", "data/images/sewer/sewer_fore.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("barrel", "data/images/sewer/broken_barrel.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("switch", "data/images/lvl_forest/switch.png",h,WM_REPEAT,WM_CLAMP,AM_MODULATE)


-- Create Level
lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also


-- Create Layers
-- The index of the layers are auto incremented. This meaning that the first one to add is 0 and rest are in order of appearance...
lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
lua:create_layer(0.2,0.2,BM_DEFAULT) -- 1 = taustavuoret
lua:create_layer(0.4,0.4,BM_DEFAULT) -- 2 = taustamets
lua:create_layer(0.75,0.75,BM_DEFAULT) -- 3 = lhipuita
local parallax_x = 1.0
local parallax_y = 1.0
local kamerapurkka = 1.0;
lua:create_layer(parallax_x,parallax_y,BM_DEFAULT) -- 4
lua:create_layer(parallax_x,parallax_y,BM_DEFAULT) -- 5
lua:create_layer(kamerapurkka , kamerapurkka ,BM_DEFAULT) -- 6 = fysiikka + pelaaja
lua:create_layer(1.0,1.0,BM_DEFAULT) -- 7 = joitain ruoho/kivijuttuja
lua:create_layer(1.3,1.3,BM_DEFAULT) -- 8 = foreground
lua:create_layer(0.0,0.0,BM_DEFAULT) -- 9 = dummy, for menus


lua:layer_color(6, 5.2, 5.2, 5.2, 1.0)
lua:init_subtexture("switch","switch_1", 0.0, 0.0, 0.5, 1.0)
lua:init_subtexture("switch","switch_2", 0.0, 0.0, 0.5, 1.0)
lua:init_subtexture("switch","switch_3", 0.5, 0.0, 1.0, 1.0)
lua:init_subtexture("switch","switch_4", 0.5, 0.0, 1.0, 1.0)

lua:init_animation("lever_open", MODE_ONCE, DIRECTION_FORWARD)
local k = 0.075
lua:animation_add_frame("lever_open","switch_1",k)
lua:animation_add_frame("lever_open","switch_2",k)
lua:init_animation("lever_close", MODE_ONCE, DIRECTION_FORWARD)
lua:animation_add_frame("lever_close","switch_3",k)
lua:animation_add_frame("lever_close","switch_4",k)

local tileSize = 256*(2/3)
local mainY = 0.0;


-- Fore Graphics
lua:create_sprite("sewer", ST_TEXTURED,"sewer_fore", 1024.0+512+128.0, 0.0) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 0.2, 0.2, 0.2 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, 3*tileSize*12, tileSize*3)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.0, 3.0, 1.0)
g_level.upload("sewer", 8)
lua:create_sprite("sewer", ST_TEXTURED,"sewer_fore", 1024.0+512.0+128, 1024.0) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 0.2, 0.2, 0.2 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, 3*tileSize*12, tileSize*3)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 1.0, 3.0, 0.0)
g_level.upload("sewer", 8)

-- Main tiles

-- basic
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset",-tileSize*2, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.5, 0.25, 1.0)
g_level.upload("sewer", 6)

-- basic
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset",0.0, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.75, 0.0, 1.0, 0.5)
g_level.upload("sewer", 6)

-- Wall ending
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset", tileSize*2, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.5, 0.25, 1.0)
g_level.upload("sewer", 6)

-- Basic with broken pipe
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset", tileSize*4, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.25, 0.5, 0.5, 1.0)
g_level.upload("sewer", 6)

-- Enterance
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset", tileSize*6, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize*2, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.5, 0.5, 1.0, 1.0)
g_level.upload("sewer", 6)



-- Basic
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset", tileSize*9, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.5, 0.25, 1.0)
g_level.upload("sewer", 6)


-- Enterance
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset", tileSize*12, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize*2, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.5, 0.5, 1.0, 1.0)
g_level.upload("sewer", 6)

--Wall Ending
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset",tileSize*15, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.75, 0.0, 1.0, 0.5)
g_level.upload("sewer", 6)

-- Basic
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset", tileSize*17, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.5, 0.25, 1.0)
g_level.upload("sewer", 6)

-- Gap start
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset", tileSize*18, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.0, 0.25, 0.5)
g_level.upload("sewer", 6)


-- Gap
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset", tileSize*20, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.25, 0.0, 0.5, 0.5)
g_level.upload("sewer", 6)

-- Gap
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset", tileSize*22, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.25, 0.0, 0.5, 0.5)
g_level.upload("sewer", 6)

-- Gap
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset", tileSize*24, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.25, 0.0, 0.5, 0.5)
g_level.upload("sewer", 6)

-- Gap
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset", tileSize*26, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.25, 0.0, 0.5, 0.5)
g_level.upload("sewer", 6)


-- Gap end
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset", tileSize*28, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.5, 0.0, 0.75, 0.5)
g_level.upload("sewer", 6)

-- Enterance
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset", tileSize*30, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize*2, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.5, 0.5, 1.0, 1.0)
g_level.upload("sewer", 6)

--Wall Ending
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset",tileSize*33, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.75, 0.0, 1.0, 0.5)
g_level.upload("sewer", 6)

-- Basic
lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset", tileSize*35, mainY) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, tileSize, tileSize*2)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.5, 0.25, 1.0)
g_level.upload("sewer", 6)


-- Main tiles end



-- Ground (upper)
groundLenght = 4
for i=0,groundLenght,1 
do
    lua:create_sprite("sewer", ST_TEXTURED,"sewer_tileset2", i*tileSize*8+tileSize*1, mainY+tileSize*3-1) -- nimi, joku, tekstuurin nimi, x, y
    lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
    lua:sprite_shape("sewer",ST_TEXTURED, tileSize*4, tileSize)
    lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.25, 1.0, 0.5)
    g_level.upload("sewer", 6)
end
-- Ground end


--running water start
local waterLenght = 5;
local waterSpdY= 0.1;
local waterY = -150;
for i=1,waterLenght,1 
do
    local waterX = -1600+i*tileSize*8*1.5

    lua:create_sprite("sewer", ST_SCROLLING,"sewer_tileset2", waterX, waterY) -- nimi, joku, tekstuurin nimi, x, y
    lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 0.3)
    lua:sprite_shape("sewer",ST_SCROLLING, tileSize*1.5*4, tileSize*1*1.5)
    lua:textured_sprite_tex_coords("sewer", ST_SCROLLING, 0.0, 0.0, 1.0, 0.25) --0.75, 0.0, 1.0, 0.15
    lua:scrolling_sprite("sewer", SS_HORIZONTAL, 0.03) -- name. type of scrolling. scrolling speed
    lua:remorfable_sprite("water", "sewer", waterSpdY, true)             -- name, sprite_name, speed, repeat

    lua:add_key_frame(0.5, waterX, waterY-30, 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,0.3)  -- r,g,b,a
    lua:upload_key_frame("water")
    
    g_level.upload("water", 6)
    
    --**2**	
    lua:create_sprite("sewer", ST_SCROLLING,"sewer_tileset2", waterX, waterY-50) -- nimi, joku, tekstuurin nimi, x, y
    lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 0.2)
    lua:sprite_shape("sewer",ST_SCROLLING, tileSize*1.5*4, tileSize*1*1.5)
    lua:textured_sprite_tex_coords("sewer", ST_SCROLLING, 0.0, 0.0, 1.0, 0.25) --0.75, 0.0, 1.0, 0.15
    lua:scrolling_sprite("sewer", SS_HORIZONTAL, 0.02) -- name. type of scrolling. scrolling speed
    lua:remorfable_sprite("water", "sewer", waterSpdY/2, true)             -- name, sprite_name, speed, repeat

    lua:add_key_frame(0.5, waterX, waterY-20, 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,0.2)  -- r,g,b,a
    lua:upload_key_frame("water")
    
    g_level.upload("water", 6)
    -- **3**
    lua:create_sprite("sewer", ST_SCROLLING,"sewer_tileset2", waterX, waterY-100) -- nimi, joku, tekstuurin nimi, x, y
    lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 0.2)
    lua:sprite_shape("sewer",ST_SCROLLING, tileSize*1.5*4, tileSize*1*1.5)
    lua:textured_sprite_tex_coords("sewer", ST_SCROLLING, 0.0, 0.0, 1.0, 0.25) --0.75, 0.0, 1.0, 0.15
    lua:scrolling_sprite("sewer", SS_HORIZONTAL, 0.01) -- name. type of scrolling. scrolling speed
    lua:remorfable_sprite("water", "sewer", waterSpdY/2, true)             -- name, sprite_name, speed, repeat

    lua:add_key_frame(0.5, waterX, waterY-100, 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
    lua:add_key_frame_color(1.0,1.0,1.0,0.2)  -- r,g,b,a
    lua:upload_key_frame("water")
    
    g_level.upload("water", 6)
    
end
--running water end

-- steam start
local steamGap = 100
local steamLenght=50

for j=0,2,1
do 
    for i=0,steamLenght,1 
    do
        local steamPlace = 0+steamGap*i
        local steamSpd = math.random()/20 + 0.05
        
        lua:create_sprite("steam", ST_TEXTURED,"sewer_steam", steamPlace, -256.0*1.5) 
        lua:sprite_shape("steam",ST_TEXTURED, 64.0, 64.0)
        lua:textured_sprite_tex_coords("steam", ST_TEXTURED,0.0, 0.0, 1.0, 1.0)
        lua:remorfable_sprite("st", "steam", steamSpd, true)             -- name, sprite_name, speed, repeat

        lua:add_key_frame(0.0, steamPlace, -256.0*1.5, 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
        lua:add_key_frame_color(1.0,1.0,1.0,0.4)  -- r,g,b,a
        lua:upload_key_frame("st")

        lua:add_key_frame(1.0, steamPlace, 0.0, 0.0, 2.0)  -- adds a new key frame. time, x, y, rotation, scale
        lua:add_key_frame_color(1.0,1.0,1.0,0.0)  -- r,g,b,a
        lua:upload_key_frame("st")

        g_level.upload("st",6)
    end
end
-- steam end



-- Objects
    
    --pipe
    lua:create_sprite("sewer", ST_TEXTURED,"sewer_objects", tileSize*3, 50.0) -- nimi, joku, tekstuurin nimi, x, y
    lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
    lua:sprite_shape("sewer",ST_TEXTURED, tileSize/4, tileSize/4)
    lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.75, 0.75, 1.0, 1.0)
    g_level.upload("sewer", 6)
    
    -- box
    lua:create_sprite("sewer", ST_TEXTURED,"sewer_objects", 2380.0, 0.0) -- nimi, joku, tekstuurin nimi, x, y
    lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
    lua:sprite_shape("sewer",ST_TEXTURED, tileSize/4, tileSize/4)
    lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.75, 0.25, 1.0)
    g_level.upload("sewer", 6)
    
    -- box
    lua:create_sprite("sewer", ST_TEXTURED,"sewer_objects", 2250.0, -10.0) -- nimi, joku, tekstuurin nimi, x, y
    lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
    lua:sprite_shape("sewer",ST_TEXTURED, tileSize/4, tileSize/4)
    lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.25, 0.75, 0.5, 1.0)
    g_level.upload("sewer", 6)
    
    
    -- barrel
    lua:create_sprite("sewer", ST_TEXTURED,"sewer_objects", 1200.0, -10.0) -- nimi, joku, tekstuurin nimi, x, y
    lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
    lua:sprite_shape("sewer",ST_TEXTURED, tileSize/4, tileSize/4)
    lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.5, 0.25, 0.75)
    g_level.upload("sewer", 6)
    
    -- emitter for barrel above
    --create the particle
    lua:create_sprite("prototype", ST_PARTICLE, "circle", 0,0)  --the translation values can be anything. They must be there for integrity but they ain't used to anything.
    lua:sprite_shape("prototype", ST_PARTICLE, 4.0,4.0)
    lua:textured_sprite_tex_coords("prototype", ST_PARTICLE, 0.0, 0.0, 1.0, 1.0)
    lua:particle_start_color("prototype", 1.0, 0.25, 0.1, 0.2) -- name: rgba-colors
    lua:particle_end_color("prototype", 0.25, 0.0, 0.0, 0.0)

    -- create the emitter
    lua:create_sprite("emitter", ST_EMITTER, "prototype", 1200.0,0) -- the translation values are on, the "texture" is the teztured particle inserted.
    lua:emitter_range("emitter", 1.0, 3.0, -1.0, 1.0, 5.0, 20.0)  --life, angular_velocity, linear_velocity
    lua:emitter_scale("emitter", true, 1.0, 3.0, 2.0, 4.0)  -- variable_scale, begin_scale_range, end_scale_range
    lua:emitter_angle("emitter", 3.14/6) -- angle. (0-PI)
    lua:emitter_timer_delay("emitter", 0.001) -- the new timer delay
    --lua:gameobject_upload("emitter",4)
    
    
    -- barrel
    lua:create_sprite("sewer", ST_TEXTURED,"sewer_objects", 1120.0, -10.0) -- nimi, joku, tekstuurin nimi, x, y
    lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
    lua:sprite_shape("sewer",ST_TEXTURED, tileSize/4, tileSize/4)
    lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.25, 0.5, 0.5, 0.75)
    g_level.upload("sewer", 6)
    
    	--unstable floor
    --lua:create_sprite("sewer", ST_TEXTURED,"sewer_unstable_floor",tileSize*20, mainY-150) -- nimi, joku, tekstuurin nimi, x, y
    --lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
    --lua:sprite_shape("sewer",ST_TEXTURED, tileSize/2, tileSize/2)
    --lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
    --g_level.upload("sewer", 6)
	--unstable floor
    --lua:create_sprite("sewer", ST_TEXTURED,"sewer_unstable_floor",tileSize*21.5, mainY-100) -- nimi, joku, tekstuurin nimi, x, y
    --lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
    --lua:sprite_shape("sewer",ST_TEXTURED, tileSize/2, tileSize/2)
    --lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
    --g_level.upload("sewer", 6)
	--unstable floor
    --lua:create_sprite("sewer", ST_TEXTURED,"sewer_unstable_floor",tileSize*23, mainY) -- nimi, joku, tekstuurin nimi, x, y
    --lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
    --lua:sprite_shape("sewer",ST_TEXTURED, tileSize/2, tileSize/2)
    --lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
    --g_level.upload("sewer", 6)
	--unstable floor
    --lua:create_sprite("sewer", ST_TEXTURED,"sewer_unstable_floor",tileSize*24.5, mainY-100) -- nimi, joku, tekstuurin nimi, x, y
    --lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
    --lua:sprite_shape("sewer",ST_TEXTURED, tileSize/2, tileSize/2)
    --lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
    --g_level.upload("sewer", 6)
	--unstable floor
    --lua:create_sprite("sewer", ST_TEXTURED,"sewer_unstable_floor",tileSize*26, mainY-150) -- nimi, joku, tekstuurin nimi, x, y
    --lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
    --lua:sprite_shape("sewer",ST_TEXTURED, tileSize/2, tileSize/2)
    --lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
    --g_level.upload("sewer", 6)
	
-- Objects end

--LEVER
local lever1 = {2800,90,g_sewer_aid.lever_map_1} --x,y,is_closed
local lever_sound = "data/music/effect_stereo.ogg"
local lever_width = 128.0 /2
local lever_height = 256.0 /2
lua:create_sprite("lever_open1", ST_ANIMATED,"lever_close", lever1[1],lever1[2]) 
lua:sprite_shape("lever_open1",ST_ANIMATED,lever_width, lever_height)
lua:create_sprite("lever_close1", ST_ANIMATED,"lever_open", lever1[1],lever1[2]) 
lua:sprite_shape("lever_close1",ST_ANIMATED,lever_width, lever_height)
--sound creation
lua:create_sound("lever_sound_open1",lever_sound, 500.0, lever1[1],lever1[2])  --name, music_name, radius, x,y
lua:create_sound("lever_sound_close1",lever_sound, 500.0, lever1[1],lever1[2])  --name, music_name, radius, x,y
lua:create_lever("lever1","lever_open1","lever_close1","lever_sound_open1","lever_sound_close1",lever1[3]) --name , open animated sprite, close animated sprite, open_sound, close_sound, is_closed
local lever1_id = g_level.upload("lever1",6)
--add trigger
switch_adv("data/scripts/test/srt_use_lever_sewer.lua",lever1[1],lever1[2],100,lever1_id) --script ,x,y, radius, id


--UNSTABLES
lua:do_file("data/scripts/inc_sewer_unstables.lua")
create_stone_unstable(3902, 59) --x,y
create_stone_unstable(3505, -29) --x,y
create_stone_unstable(4338, -32) --x,y

--Nuclear Barrels
lua:create_sprite("sewer", ST_TEXTURED,"barrel", 1010.0 , 420.0) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, 64, 64)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("sewer", 6)
lua:create_sprite("sewer", ST_TEXTURED,"barrel", 3800.0 , 420.0) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, 64, 64)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("sewer", 6)
lua:create_sprite("sewer", ST_TEXTURED,"barrel", 4050.0 , 420.0) -- nimi, joku, tekstuurin nimi, x, y
lua:sprite_color("sewer", 1.0, 1.0, 1.0 , 1.0)
lua:sprite_shape("sewer",ST_TEXTURED, 64, 64)
lua:textured_sprite_tex_coords("sewer", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)
g_level.upload("sewer", 6)

--BULLETS
lua:do_file("data/scripts/inc_poison_bullet.lua")
local spd = 0.4
--first poison drop
local path_list = {}
table.insert(path_list,{1010.0,390.0,0.0}) --x,y, time
table.insert(path_list,{1010.0,-200.0,1.0}) --x,y, time
create_poison_bullet(path_list, true, spd, 6)--path_list, is_repeating,speed ,layer
--second poison drop
local path_list = {}
table.insert(path_list,{3790.0,390.0,0.0}) --x,y, time
table.insert(path_list,{3790.0,-200.0,1.0}) --x,y, time
create_poison_bullet(path_list, true, spd, 6)--path_list, is_repeating,speed ,layer
--third poison drop
local path_list = {}
table.insert(path_list,{4041.0,390.0,0.0}) --x,y, time
table.insert(path_list,{4041.0,-200.0,1.0}) --x,y, time
create_poison_bullet(path_list, true, spd-0.05, 6)--path_list, is_repeating,speed ,layer

--STOPPERS
--walls
stopper(LEFT,76) --far left
--second
lua:create_shape("generic_name_vol1",PSC_RECTANGLE,123/2,1000.0) -- name, type, width, height
lua:create_collider(1111,"generic_name_vol1",2583,0.0) --id, shape, x ,y
--far right
stopper(RIGHT,5591.0) --id, shape, x ,y

--boxes
--left
--lua:create_shape("generic_name_vol1",PSC_RECTANGLE,67,53.0) -- name, type, width, height
--lua:create_collider(1111,"generic_name_vol1",1157,-40.0) --id, shape, x ,y
--center
--lua:create_shape("generic_name_vol1",PSC_RECTANGLE,29.5,54.0) -- name, type, width, height
--lua:create_collider(1111,"generic_name_vol1",2246.5,-40.0) --id, shape, x ,y
--right
--lua:create_shape("generic_name_vol1",PSC_RECTANGLE,27.5,60.0) -- name, type, width, height
--lua:create_collider(1111,"generic_name_vol1",2376.5,-40.0) --id, shape, x ,y


--Segments start
lua:create_segment(-240, -40)
lua:add_segment(939, -38)
lua:add_segment(949, -50)
lua:upload_segmentstrip()

lua:create_segment(1061.53, -46)
lua:add_segment(1067.53, -38)
--lua:add_segment(1085.53, -31)
--lua:add_segment(1089.53, 5)
--lua:add_segment(1141.53, 7)
--lua:add_segment(1163.53, 3.00003)
--lua:add_segment(1182.53, 25)
--lua:add_segment(1219.53, 23)
--lua:add_segment(1230.53, -13)
lua:add_segment(1239.53, -39)
lua:add_segment(1964.53, -39)
lua:add_segment(1973.53, -48)
lua:upload_segmentstrip()

lua:create_segment(2085.1, -46)
lua:add_segment(2091.1, -38)
lua:add_segment(2200.1, -37)
--lua:add_segment(2221.1, 16)
--lua:add_segment(2270.1, 14)
--lua:add_segment(2291.1, -26)
--lua:add_segment(2343.1, -30)
--lua:add_segment(2353.1, 21)
--lua:add_segment(2405.1, 20)
lua:add_segment(2413.1, -37)
lua:add_segment(3214.1, -37)
lua:add_segment(3219.1, -44)
lua:upload_segmentstrip()

lua:create_segment(4621.21, -36.8532)
lua:add_segment(4631.12, -26.8532)
lua:add_segment(5037.12, -35.8532)
lua:add_segment(5040.12, -42.8532)
lua:upload_segmentstrip()

lua:create_segment(5167.69, -30.8533)
lua:add_segment(5173.94, -22.8532)
lua:add_segment(6033.12, -25.8532)
lua:upload_segmentstrip()


--lua:create_segment(-345, -40)
--lua:add_segment(4095, -40)
--lua:upload_segmentstrip()

fade_in(2)
timer(2,"data/scripts/dialogs/dia_sewer_start.lua")

--Segments end
--4
switch_adv("data/scripts/srt_sewer_next_level.lua",1037, 70,200,604) --script, x, y, radius, id
--5
switch_adv("data/scripts/srt_sewer_next_level.lua",2059, 79,200,605) --script, x, y, radius, id
--6
switch_adv("data/scripts/srt_sewer_next_level.lua",5138, 83,200,606) --script, x, y, radius, id
--secure kill
trigger("data/scripts/srt_game_over.lua","",30000,100,10820,-350) --script, width, height, x, y

--SEWER PIPE SETTINGS
g_sewer_aid.set_map_id(1)

--Player
--INIT PLAYER
lua:do_file("data/scripts/crt_player_trigger.lua",0)
lua:init_camera_binder(-256.0, 6095.0, -350.0, 510.0) -- left, right, bottom, up
lua:upload_player_to_layer(6)  --index of the layer
if g_sewer_aid.get_prev_map_id() == 4 then 
    lua:creature_translation("player", CPT_PLAYER, 800.0,150.0) -- set the player to it's right position
elseif g_sewer_aid.get_prev_map_id() == 5 then 
    lua:creature_translation("player", CPT_PLAYER, 2209.0,150.0) -- set the player to it's right position
elseif g_sewer_aid.get_prev_map_id() == 6 then  
    lua:creature_translation("player", CPT_PLAYER, 5278.0,150.0) -- set the player to it's right position
else
    lua:creature_translation("player", CPT_PLAYER, 400.0,150.0) -- set the player to it's right position
end
--Player end


lua:set_game_state(GS_PLAY) -- sets the game state to menu. thus you are able to use the menu commands
